eval '(exit $?0)' && eval 'exec perl -S $0 ${1+"$@"}' && eval 'exec perl -S $0 $argv:q'
        if 0;

#####################################################
#                                                   #
# This script reads the disampled type1 font .pfa   #
# file (use eg. t1disasm to do this) and converts   #
# it to a SVG font. The script won't work if the    #
# t1 contains a "seac" command. For more than 999   #
# glyphs the script will need to be extended.       #
#                                                   #
# modified, Mon Apr  7 2003 (MG)                    #
# - eliminate fill:#000000; from style on path      #
#   descriptions of glyphs in font (to allow        #
#   different colors for the strokes)               # 
#                                                   #
# modified, Fri Mar 28 2003 (MG)                    #
# - generalize code to treat "dup 3/tilde put"      #
#   instead of               "dup 3 /tilde put"     #
# - store $code (3) and $name (tilde) only          #
#                                                   # 
# modified, Fri Feb  8 2002                         #
# - get $code and $name from "dup" lines (MG)       # 
# - write hex code from $code on <glyph ... (MG)    # 
#                                                   # 
# modified, Wed Feb  6 2002                         #
# - get fontname from /FontName in font (MG)        # 
# - eliminate svg and defs containers (MG)          # 
# - always print missing glyph (MG)                 # 
#                                                   # 
# modified, Tue Oct  9 10:01:20 CEST 2001           #
# -comments added                                   #
#                                                   #
# to do:                                            #
# -include type1 "seac" command                     #
#                                                   #
# michel.goossens@cern.ch                           #
# Vesa.Sivunen@cern.ch                              #
#                                                   #
#####################################################

# Read the filename and print usage message if empty.

 $infilename = $ARGV[0];
 
 if ($infilename eq "") {
     print "usage: type1svg input.disasm\n"; 
     exit;
 }

# Open the type1 file and read it @disasm array.

 open (IN,"$infilename") || die "cannot open $infilename1";
 @disasm = (<IN>);
 close (IN);

#
# Extract the glyph names and put them into @allnames. 
# This should be rewritten. This quick and dirty version works 
# now if the name line has "dup", a number (one or more digits) and the glyphname. 
#

 foreach (@disasm) {
# Take care of fact that space before name "/dup a/Name put" can be absent
     if (((grep(/^ *dup *\d* *\/.*put/,$_)) == 1)) {
# Get rid of "dup" and "put" plus surrounding spaces
	 $junk = substr($_,0,-1);
	 $junk =~ s/^ *dup *//;  
	 $junk =~ s/ *put *//;  
# Replace "/" by space to separate name and code
	 $junk =~ s/\// /;
# Replace multiple spaces by one space
	 $junk =~ s/ +/ /;
         push (@allnames,"$junk ");
     } 
#       Get fontname in uppercase from /FontName declaration in T1 definition
     if (((grep(/FontName \//,$_)) == 1)) {
#     Get rid of last character (\n)
     $fontname = substr($_,0,-1);
     $fontname =~ s/^\s*\/FontName\s*\///;
     $fontname =~ s/\s*def$//;
#       Get rid of digits, remaining spaces, and uppercase name
     $fontname =~ tr/a-z/A-Z/;
     $fontname =~ s/\d*$//;
     $fontname =~ s/\s*//;
     }
 }

# Figure out the last glyph and set the counter to 0.

 $lastallnames = $#allnames;

 $i=0;

# 
# Here starts the first round to create SVG, data is 
# extracted and modified to @ready_lines and @ready_temp 
# arrays from @disasm array.
#
# Fore each line in @allnames undef the glyphname and hex-value and 
# extract the plain glyphname and set $i2 to 0.
# 


 foreach (@allnames) {
     undef $name;
     undef $hex;
# extract numeric code and name (format of line is: "name code ")
     ($code, $name) = split(/ /, $_); 
# counter for present character
     $i2=0;

#
# For each line in @disasm 
#   if the "glyphname {" is found and
#   there is "hsbw" in next two lines:
#     Put first line after glyphname in @ready_lines array to    
#     count later the horiz-adv-x value and currentpoint,
#     remove "/" from name and give as glyphname
#     get hex-value $hex using $code (from dup vector).
#       and add "&#xE...;" to map onto private area;
#     Write the first line of the SVG font to @ready_temp array
#     and set the $l to 1.
#         Put everything to @ready_temp and add 1 to $l until 
#         "endchar" is found.
#     Add SVG closepath z and end tag for glyph.             
#
#   Add 1 to $i2.
#   Last line if the "glyphname {" is found and
#   there is "hsbw" in next two lines.
#   Add 1 to $i. (Continue the for each line loop 
#   with @allnames.)  


     foreach (@disasm) {
         if (((grep(/^\s*?\/$name {/,$_)) == 1) && 
            (((grep(/hsbw/,$disasm[$i2+1])) == 1) ||
            ((grep(/hsbw/,$disasm[$i2+2])) == 1))) {
             push (@ready_lines,"$disasm[$i2+1]");
#             $name =~ s/\///;
# Calculate hex value from decimal character code
             $hex = sprintf "%3.3X", $code;
             $hex = "&#xE$hex\;";

             push (@ready_temp,"<glyph unicode=\"$hex\"");
             push (@ready_temp," glyph-name=\"$name\" horiz-adv-x=\"\">\n");
             $l=1;
                 until ((grep(/endchar/,$disasm[$i2+$l])) == 1) {  
                     push (@ready_temp,"$disasm[$i2+$l]");
                     $l++; 
                 }
             push (@ready_temp,"z\"/>\n</glyph>\n\n");
         } 
 
     $i2++;
     last if (((grep(/^$name {/,$_)) == 1) && 
               (((grep(/hsbw/,$disasm[$i2+1])) == 1) ||
	       ((grep(/hsbw/,$disasm[$i2+2])) == 1)));
     }
     $i++;
 }

#
# The values for horiz-adv-x and current point...
#
# For each line
#   if there is "div" command        
#     extract values and divide.
#     Put the ready two values
#     into @ready_disasm array.
#   Else 
#     extract and put the ready two 
#     values into @ready_disasm array.
#

 foreach (@ready_lines) {
     if ((grep(/div/,$_)) == 1){
         $_ =~ s/^\s+//;
         $a1 = $_;
         $a1 =~ s/ .*.//;
         chop($a1);
         chop($_);
         $_ =~ s/.*?. //;
         $a2 = $_;
         $b = $_;
         $a2 =~ s/ .*.//;
         $b =~ s/ div//;
         $b =~ s/.*. //;
         $c = $a2 / $b;
         $c = sprintf("%.1f", $c);
         push (@ready_disasm,"$a1 $c");
     }
     else {
         $_ =~ s/^\s+//;
         $a = $_;
         $a =~ s/ .*.//;
         chop($a);
         $c = $_;
         $c =~ s/.*?. //;
         $c =~ s/ hsbw//;
         chop($c);chop($_);
         push (@ready_disasm,"$a $c");
     }
 }

# The helper counters set to 0.

 $i3=0;
 $i4=0;


#
# Here is the "main" part of the script, where 
# type1 values are converted into SVG.
#
# For each line in @ready_temp:
#   add 1 to $i4 and undefine the variables.
#   If there is "horiz-adv-x":
#      take the two values from @ready_disasm 
#      and place the second one to horiz-adv-x 
#      value and the first one to current point x.
#      Put the ready beginning of the SVG-glyph into
#      @ready array and add 1 to $i3 counter.
#   Else if there is string: "hsbw, hstem, vstem, hstem3
#      vstem3, callsubr, callothersubr, pop or closepath" 
#      and z do nothing.
#   Else if there is closepath and z
#      put z, newline and M plus currentpoints to @ready.
#   
#   What follows are else if statements where firstly 
#   the type1 command is searched and if found the 
#   values are translated to SVG equivalents as shown 
#   in the table:
#
#   Type1     |  SVG      | Current point
#   -----------------------------------------
#   hlineto   | h a1      | currentpointx = currentpointx + a1
#   hmoveto   | m a1 0    | currentpointx = currentpointx + a1
#   hvcurveto | c a1 0    | currentpointx = currentpointx + a1 + a2 
#             | (a1+a2) a3| currentpointy = currentpointy + a3 + a4
#             | (a1+a2)   |
#             | (a3+a4)   |
#   rlineto   | l a1 a2   | currentpointx = currentpointx + a1
#             |           | currentpointy = currentpointy + a2
#   rmoveto   | m $a1 $a2 | currentpointx = currentpointx + a1
#             |           | currentpointy = currentpointy + a2
#   rrcurveto | c a1 a2   | currentpointx = currentpointx + a1 + a3 + a5
#             | (a1+a3)   | currentpointy = currentpointy + a2 + a4 + a6
#             | (a2+a4)   | 
#             | (a1+a3+a5)| 
#             | (a2+a4+a6)|
#   vlineto   | v a1      | currentpointy = currentpointy + a1
#   vmoveto   | m 0 a1    | currentpointy = currentpointy + a1
#   vhcurveto | c 0 a1 a2 | currentpointx = currentpointx + a2 + a4
#             | (a1+a3)   | currentpointy = currentpointy + a1 + a3
#             | (a2+a4)   |
#             | (a1+a3)   |
#




 foreach (@ready_temp) {
     $i4++;
     undef $a1;undef $a2;
     undef $a3;undef $a4;
     undef $a5;undef $a6;

     if ((grep(/horiz-adv-x/,$_)) == 1){
         $a1 = $ready_disasm[$i3];
         $a2 = $ready_disasm[$i3];
         $a1 =~ s/ .*.//;
         $currentpointx=$a1;
         $currentpointy=0;
         $a2 =~ s/.*. //;
         $_ =~ s/\n//;
         $_ =~ s/horiz-adv-x.*.>/horiz-adv-x=\"$a2\"\>/;
         $_ =~ s/>/>\n<path style=\"fill-rule=evenodd\; stroke:none\" d=\"M $a1 0 /;
         push (@ready,"$_");
         $i3++;
     } 

     elsif (((grep(/div/,$_)) == 1) ||
            ((grep(/hsbw/,$_)) == 1) ||
            ((grep(/hstem/,$_)) == 1) ||
            ((grep(/vstem/,$_)) == 1) ||
            ((grep(/hstem3/,$_)) == 1) ||
            ((grep(/vstem3/,$_)) == 1) ||
            ((grep(/callsubr/,$_)) == 1) ||
            ((grep(/callothersubr/,$_)) == 1) ||
            ((grep(/pop/,$_)) == 1) ||
            (((grep(/closepath/,$_)) == 1) && 
            ((grep(/z\"\/>/,$ready_temp[$i4])) == 1)))
     {} 

     elsif (((grep(/closepath/,$_)) == 1) && 
            ((grep(/z\"\/>/,$ready_temp[$i4])) == 0)) {
         push (@ready,"z\nM $currentpointx $currentpointy ");
     }

     elsif ((grep(/hlineto/,$_)) == 1) {
         undef @hlineto;
         $_ =~ s/^\s+//;
         @hlineto = split(/ /, $_);
         $a1=$hlineto[0];
         $currentpointx = $currentpointx + $a1;
         push (@ready,"h $a1 ");
     }

     elsif ((grep(/hmoveto/,$_)) == 1) {
         undef @hmoveto;
         $_ =~ s/^\s+//;
         @hmoveto = split(/ /, $_);
         $a1=$hmoveto[0];
         $currentpointx = $currentpointx + $a1;
         push (@ready,"m $a1 0 ");
     }

     elsif ((grep(/hvcurveto/,$_)) == 1) {
         undef @hvcurveto;
         $_ =~ s/^\s+//;
         @hvcurveto = split(/ /, $_);
         $a1=$hvcurveto[0];$a2=$hvcurveto[1];
         $a3=$hvcurveto[2];$a4=$hvcurveto[3];
         $a1a2 = $a1 + $a2;
         $a3a4 = $a3 + $a4;
         $currentpointx = $currentpointx + $a1 + $a2;
         $currentpointy = $currentpointy + $a3 + $a4;
         push (@ready,"c $a1 0 $a1a2 $a3 $a1a2 $a3a4 ");
     }

     elsif ((grep(/rlineto/,$_)) == 1) {
         undef @rlineto;
         $_ =~ s/^\s+//;
         @rlineto = split(/ /, $_);
         $a1=$rlineto[0];$a2=$rlineto[1];
         $currentpointx = $currentpointx + $a1;
         $currentpointy = $currentpointy + $a2;
         push (@ready,"l $a1 $a2 ");
     }

     elsif ((grep(/rmoveto/,$_)) == 1) {
         undef @rmoveto;
         $_ =~ s/^\s+//;
         @rmoveto = split(/ /, $_);
         $a1=$rmoveto[0];$a2=$rmoveto[1];
         $currentpointx = $currentpointx + $a1;
         $currentpointy = $currentpointy + $a2;
         push (@ready,"m $a1 $a2 ");
     }

     elsif ((grep(/rrcurveto/,$_)) == 1) {
         undef @rrcurveto;
         $_ =~ s/^\s+//;
         @rrcurveto = split(/ /, $_);
         $a1=$rrcurveto[0];$a2=$rrcurveto[1];
         $a3=$rrcurveto[2];$a4=$rrcurveto[3];
         $a5=$rrcurveto[4];$a6=$rrcurveto[5];
         $a1a3 = $a1 + $a3;
         $a2a4 = $a2 + $a4;
         $a1a3a5 = $a1 + $a3 + $a5;
         $a2a4a6 = $a2 + $a4 + $a6;
         $currentpointx = $currentpointx + $a1 + $a3 + $a5;
         $currentpointy = $currentpointy + $a2 + $a4 + $a6;
         push (@ready,"c $a1 $a2 $a1a3 $a2a4 $a1a3a5 $a2a4a6 ");
     }

     elsif ((grep(/vlineto/,$_)) == 1) {
         undef @vlineto;
         $_ =~ s/^\s+//;
         @vlineto = split(/ /, $_);
         $a1=$vlineto[0];
         $currentpointy = $currentpointy + $a1;
         push (@ready,"v $a1 ");
     }

     elsif ((grep(/vmoveto/,$_)) == 1) {
         undef @vmoveto;
         $_ =~ s/^\s+//;
         @vmoveto = split(/ /, $_);
         $a1=$vmoveto[0];
         $currentpointy = $currentpointy + $a1;
         push (@ready,"m 0 $a1 ");
     }

     elsif ((grep(/vhcurveto/,$_)) == 1) {
         undef @vhcurveto;
         $_ =~ s/^\s+//;
         @vhcurveto = split(/ /, $_);
         $a1=$vhcurveto[0];$a2=$vhcurveto[1];
         $a3=$vhcurveto[2];$a4=$vhcurveto[3];
         $a1a3 = $a1 + $a3;
         $a2a4 = $a2 + $a4;
         $currentpointx = $currentpointx + $a2 + $a4;
         $currentpointy = $currentpointy + $a1 + $a3;
         push (@ready,"c 0 $a1 $a2 $a1a3 $a2a4 $a1a3 ");
     }

     else {
         push (@ready,"$_");
     }   
    
 }


#
# 
# Take care that lines are not longer than 72
# characters.
#

 foreach (@ready) {
     $all = $all.$_;
 }



 @makelinebreaks = split(/\n/, $all);

 foreach (@makelinebreaks) {
     if ((grep(/glyph unicode/,$_)) == 1) {
         $_ =~ s/$/\n/;
     }
     if ((grep(/glyph unicode/,$_)) == 0) {
         $line = $_;
         until (length($line) < 72) {
    	     $newline =  substr($line,0,72);
	     $line =  substr($line,72);
             $newline =~ s/\s([^ ]*)$/\n$1/;         
             push (@ready_linesok,"$newline");
         }
         push (@ready_linesok,"$line\n");
     }
     else {
         push (@ready_linesok,"$_");
     }
 }


#
# Print the SVG font. Add necessary XML stuff in 
# the beginning and in the end. Some fonts may have 
# "holes", that is missing glyphs. If so, you can 
# uncomment the <missing-glyph> line.
#

# print "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
# print "<svg xmlns = \'http://www.w3.org/2000/svg\'>\n\n";
# print "<defs>\n";
 print "<font id=\"$fontname\">\n";
 print "<font-face font-family=\"$fontname\"/>\n\n"; 

# if ($lastallnames ne 127) {
 print "<missing-glyph><path d=\"M0,0h200v200h-200z\"/></missing-glyph>\n";
# }

 print "\n";
 print @ready_linesok;
 print "\n</font>\n";
# print "</defs>\n";
# print "</svg>\n\n";







